<!DOCTYPE html>
<html>
% import random
% include('header_study.tpl', title='A typographical study', parameter = para)

<body>
    <div class="container">
      <h1>Judge the {{para}} of the top word</h1>

      <div class="range-slider">
        <p>Set the nob of the slider to where you think the appearance of the top word is in between the two lower words. <strong>The meaning of the words is irrelevant!</strong></p>
        <!-- <h2>{{ para }}</h2> -->

        <form action="./ajax" method='post' id="the_form">
        <formfield>          

          <p class="stimuli center target" id='C'>{{ test_word[2] }}</p>
          <input id="nextButton" class="center" type="submit" value="OK" disabled>
          <input name='user_input' class="input-range" type="range" id="set_value" min="0" max="100" value= {{ knob }} step="1" />
          <!-- <output for="user_input" onforminput="value = user_input.valueAsNumber;"></output> -->
          
          % if para == 'aperture':
            <p class="stimuli B range-label">{{ test_word[0] }}</p>
            <p class="stimuli A range-label">{{ test_word[0] }}</p>
          % else:
            <p class="stimuli A range-label">{{ test_word[0] }}</p>
            <p class="stimuli B range-label">{{ test_word[0] }}</p>
          % end
          
          <input type="hidden" name="valueKnob" id="valueKnob" value={{ knob }}>
          <input type="hidden" name="axis_para_min" id="axis_para_min" value={{ axis_para[0] }}>
          <input type="hidden" name="axis_para_max" id="axis_para_max" value={{ axis_para[1] }}>
          <input type="hidden" name="increments" id="increments" value={{ increments }}>

        </formfield>
        </form>
        <p id="control">&nbsp;</p>
        <p class="center"> Trial <span id='count_'>1</span> of {{ trials_amount }}</p>

      </div>
    </div>

% include('footer.tpl')

    <script>
    var url_part = { exp: {{!'"%s"' % exp }}, para: {{!'"%s"' % para }} };
    var roundCount = {{ round }};
    var axis_seg_low = {{ axis_segment[0] }};
    var axis_seg_high = {{ axis_segment[1] }};
    var trial_array = {{ sorted([t[2] for t in trials]) }};
    var collect = {{  collect }};
    var allTrials =  {{ !allTrials }} ;
    var segment = {{ allTrials[0]['seg'] }};
    var decimals = {{ decimals }};
    var trials_amount = {{ trials_amount }};
    </script>
    <script src="/assets/js/jquery-1.11.3.min.js"></script>
    <script src="/assets/js/slider.js"></script>
    <script src="/assets/js/fontfaceobserver.js"></script>
    <script src="/assets/js/ok_placing.js"></script>
     
</body>
</html>